/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block.enchantal_cooler;

import com.renyigesai.immortalers_delight.block.WrappedHandler;
import com.renyigesai.immortalers_delight.block.enchantal_cooler.EnchantalCoolerBlock;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightBlocks;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import com.renyigesai.immortalers_delight.recipe.EnchantalCoolerRecipe;
import com.renyigesai.immortalers_delight.recipe.PillagerKnifeAddPotionRecipe;
import com.renyigesai.immortalers_delight.screen.EnchantalCoolerMenu;
import com.renyigesai.immortalers_delight.util.ItemUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantalCoolerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private final ItemStackHandler inventory = new ItemStackHandler(7);
    public int cookingTotalTime;
    public int residualDye;
    public int loadVersion = 11;
    public static final int CONTAINER_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    public static final int FUEL_SLOT = 6;
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3};
    private static final int[] OUTPUT_SLOTS = new int[]{5};
    private static final int[] FUEL_SLOTS = new int[]{6};
    private static final int[] CONTAINER_SLOTS = new int[]{4};
    private boolean newVersion = false;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final EnumMap<Direction, LazyOptional<WrappedHandler>> directionHandlers = new EnumMap(Direction.class);

    public EnchantalCoolerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ImmortalersDelightBlocks.ENCHANTAL_COOLER_ENTITY.get(), pos, state);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.immortalers_delight.enchantal_cooler");
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory playerInventory) {
        return new EnchantalCoolerMenu(containerId, playerInventory, this);
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private boolean hasInput() {
        for (int i = 0; i < 4; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private boolean fuelSupplement() {
        return this.residualDye < 3;
    }

    private boolean isFuelEmpty() {
        return this.residualDye == 0;
    }

    public boolean isFuel(ItemStack fuel) {
        return fuel.m_150930_(Items.f_42534_) || fuel.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("immortalers_delight:enchantal_cooler_fuel")));
    }

    public boolean getIntList(int i, int[] intList) {
        for (int j = 0; j < intList.length; ++j) {
            if (intList[j] != i) continue;
            return true;
        }
        return false;
    }

    private Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)EnchantalCoolerBlock.FACING);
    }

    public void drops(EnchantalCoolerBlockEntity blockEntity) {
        SimpleContainer inventory = new SimpleContainer(blockEntity.inventory.getSlots());
        for (int i = 0; i < blockEntity.inventory.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.inventory.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        return stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41620_(amount);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void onLoad() {
        super.onLoad();
        Direction facing = this.getDirection();
        this.lazyItemHandler = LazyOptional.of(() -> this.inventory);
        this.directionHandlers.put(Direction.UP, (LazyOptional<WrappedHandler>)LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.inventory, i -> false, (i, s) -> this.getIntList((int)i, INPUT_SLOTS) && this.m_7013_((int)i, (ItemStack)s))));
        this.directionHandlers.put(Direction.DOWN, (LazyOptional<WrappedHandler>)LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.inventory, i -> this.getIntList((int)i, OUTPUT_SLOTS), (i, s) -> false)));
        this.directionHandlers.put(facing, (LazyOptional<WrappedHandler>)LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.inventory, i -> false, (i, s) -> this.getIntList((int)i, FUEL_SLOTS))));
        for (Direction dir : Direction.values()) {
            if (dir == Direction.UP || dir == Direction.DOWN || dir == facing) continue;
            this.directionHandlers.put(dir, (LazyOptional<WrappedHandler>)LazyOptional.of(() -> new WrappedHandler((IItemHandlerModifiable)this.inventory, i -> false, (i, s) -> this.getIntList((int)i, CONTAINER_SLOTS) && this.m_7013_((int)i, (ItemStack)s))));
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (this.isMigration(tag)) {
            ItemStackHandler newInventory = new ItemStackHandler(7);
            ItemStackHandler oldInventory = new ItemStackHandler(5);
            ItemStackHandler oldFuel = new ItemStackHandler(1);
            ItemStackHandler oldContainerslot = new ItemStackHandler(1);
            if (tag.m_128441_("Inventory")) {
                oldInventory.deserializeNBT(tag.m_128469_("Inventory"));
                this.inventory.deserializeNBT(newInventory.serializeNBT());
            }
            if (tag.m_128441_("Containerslot")) {
                oldContainerslot.deserializeNBT(tag.m_128469_("Containerslot"));
            }
            if (tag.m_128441_("Fuelslot")) {
                oldFuel.deserializeNBT(tag.m_128469_("Fuelslot"));
            }
            this.inventory.setStackInSlot(0, oldInventory.getStackInSlot(0));
            this.inventory.setStackInSlot(1, oldInventory.getStackInSlot(1));
            this.inventory.setStackInSlot(2, oldInventory.getStackInSlot(2));
            this.inventory.setStackInSlot(3, oldInventory.getStackInSlot(3));
            this.inventory.setStackInSlot(5, oldInventory.getStackInSlot(4));
            this.inventory.setStackInSlot(4, oldContainerslot.getStackInSlot(0));
            this.inventory.setStackInSlot(6, oldFuel.getStackInSlot(0));
        } else if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
        this.cookingTotalTime = tag.m_128451_("CookingTotalTime");
        this.residualDye = tag.m_128451_("ResidualDye");
        this.loadVersion = tag.m_128451_("LoadVersion");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("CookingTotalTime", this.cookingTotalTime);
        tag.m_128405_("ResidualDye", this.residualDye);
        tag.m_128405_("LoadVersion", 11);
    }

    private boolean isMigration(CompoundTag tag) {
        if (!tag.m_128441_("LoadVersion")) {
            return true;
        }
        if (tag.m_128451_("LoadVersion") == this.loadVersion) {
            return false;
        }
        return tag.m_128451_("LoadVersion") < this.loadVersion;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public static void craftTick(Level level, BlockPos pos, BlockState state, EnchantalCoolerBlockEntity blockEntity) {
        boolean flag = false;
        if (!blockEntity.isFuelEmpty() && blockEntity.hasInput()) {
            flag = true;
            blockEntity.craftItem();
        }
        if (blockEntity.fuelSupplement()) {
            flag = true;
            blockEntity.fillFuel();
        }
        if (flag) {
            EnchantalCoolerBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (!level.f_46443_) {
                level.m_7260_(pos, state, state, 3);
            }
        }
    }

    private Optional<EnchantalCoolerRecipe> getCurrentRecipe() {
        SimpleContainer inventory = this.getInput(true);
        if (this.f_58857_ != null) {
            return this.f_58857_.m_7465_().m_44015_((RecipeType)EnchantalCoolerRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        }
        return Optional.empty();
    }

    private Optional<PillagerKnifeAddPotionRecipe> findSpecialRecipe() {
        SimpleContainer inventory = this.getInput(true);
        if (this.f_58857_ != null) {
            return this.f_58857_.m_7465_().m_44015_((RecipeType)PillagerKnifeAddPotionRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        }
        return Optional.empty();
    }

    private SimpleContainer getInput(boolean needContainer) {
        int i;
        SimpleContainer inventory = new SimpleContainer(needContainer ? 5 : 4);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        if (needContainer) {
            inventory.m_6836_(4, this.inventory.getStackInSlot(4));
        }
        for (i = 0; i < 4; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            inputs.add(stack);
        }
        for (i = 0; i < inputs.size(); ++i) {
            inventory.m_6836_(i, (ItemStack)inputs.get(i));
        }
        return inventory;
    }

    private void craftItem() {
        ItemStack outputStack;
        SimpleContainer inputs;
        Optional<PillagerKnifeAddPotionRecipe> specialRecipe = this.findSpecialRecipe();
        Optional<EnchantalCoolerRecipe> recipeOptional = this.getCurrentRecipe();
        if (specialRecipe.isEmpty() && recipeOptional.isEmpty()) {
            this.cookingTotalTime = 0;
            return;
        }
        EnchantalCoolerRecipe recipe = specialRecipe.isEmpty() ? recipeOptional.get() : (EnchantalCoolerRecipe)specialRecipe.get();
        ItemStack resultItem = recipe.assemble(inputs = this.getInput(true), this.f_58857_.m_9598_()).m_41777_();
        if (!this.canCraft(resultItem, outputStack = this.inventory.getStackInSlot(5))) {
            this.cookingTotalTime = 0;
            return;
        }
        if (this.cookingTotalTime < 100) {
            ++this.cookingTotalTime;
        } else {
            for (int slot = 0; slot < 4; ++slot) {
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.m_150930_(Items.f_42447_)) continue;
                if (stack.hasCraftingRemainingItem()) {
                    this.ejectIngredientRemainder(stack.getCraftingRemainingItem());
                }
                this.inventory.extractItem(slot, 1, false);
            }
            if (!recipe.getContainer().m_41619_()) {
                this.inventory.extractItem(4, 1, false);
            }
            if (!this.ejectIngredientJvav(this.f_58857_)) {
                if (outputStack.m_41619_()) {
                    this.inventory.setStackInSlot(5, resultItem);
                } else {
                    outputStack.m_41769_(resultItem.m_41613_());
                }
            }
            --this.residualDye;
            this.cookingTotalTime = 0;
        }
    }

    private boolean ejectIngredientJvav(Level level) {
        if (level.m_204166_(this.f_58858_).m_203656_(BiomeTags.f_207610_) && Math.random() < 0.00947) {
            ItemUtils.spawnItemEntity(this.f_58857_, new ItemStack((ItemLike)ImmortalersDelightItems.JVAV_OFFEE.get()), (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5625, (double)this.f_58858_.m_123343_() + 0.5, 0.0, 0.25, 0.0);
            return true;
        }
        return false;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        double x = (double)this.f_58858_.m_123341_() + 0.5;
        double y = (double)this.f_58858_.m_123342_() + 0.5;
        double z = (double)this.f_58858_.m_123343_() + 0.5;
        ItemUtils.spawnItemEntity(this.f_58857_, remainderStack, x, y, z, 0.0, 0.0, 0.0);
    }

    private void fillFuel() {
        ItemStack stack = this.inventory.getStackInSlot(6);
        if (this.isFuel(stack)) {
            ++this.residualDye;
            stack.m_41774_(1);
        }
    }

    private boolean canCraft(ItemStack resultItem, ItemStack outputStack) {
        if (outputStack.m_41619_()) {
            return true;
        }
        return resultItem.m_150930_(outputStack.m_41720_()) && outputStack.m_41613_() != outputStack.m_41741_();
    }

    public int @NotNull [] m_7071_(Direction pSide) {
        if (pSide == this.getDirection()) {
            return FUEL_SLOTS;
        }
        if (pSide == Direction.DOWN) {
            return OUTPUT_SLOTS;
        }
        return pSide == Direction.UP ? INPUT_SLOTS : CONTAINER_SLOTS;
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return pIndex != 5;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return this.m_7013_(pIndex, pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.directionHandlers.getOrDefault(side, (LazyOptional<WrappedHandler>)LazyOptional.empty()).cast();
        }
        return super.getCapability(cap, side);
    }
}

